
#########################################################################################
## ANOVA 1 FACTOR
#########################################################################################

##########################################################################################
##   EXEMPLE COT: resistencia a la tensin de una nueva fibra sinttica
##########################################################################################


# Un ingeniero de desarrollo de productos est interesado en maximizar la
# resistencia a la tensin de una nueva fibra sinttica que se emplear en la manufactura
# de tela para camisas de hombre. El ingeniero sabe por experiencia que la resistencia
# est influida por el porcentaje de algodn presente en la fibra. Adems, sospecha que el
# contenido de algodn debe estar aproximadamente entre un 10 y 40% para que la tela
# resultante tenga otras caractersticas de calidad que se desean (como la capacidad de
# recibir un tratamiento de planchado permanente). El ingeniero decide probar muestras a
# cinco niveles de porcentaje de algodn: 15, 20, 25, 30 y 35%. Asimismo, decide ensayar
# cinco muestras a cada nivel de contenido de algodn. Probar si existe relacin entre la 
# resistencia y el % de algodn.

getwd() # En qu carpeta estamos?
setwd() # Para fijar la carpeta de trabajo
coto <- read.table("./dades/coto.txt", header=TRUE)
class(coto)
str(coto)

# debemos convertir la variable grupo a factor
coto$grupo <- factor(coto$grupo, labels=c("15%","20%","25%","30%","35%"))
class(coto$grupo)

attach(coto)

## Estadstica descriptiva

tapply(medida, grupo, mean) # medias
tapply(medida, grupo, median) # medianas
tapply(medida, grupo, function(x) sum(!is.na(x))) # counts
tapply(medida, grupo, sd) # std. deviations
tapply(medida, grupo, summary) # resumen

boxplot(medida ~ grupo, ylab="Resistencia", xlab="Porcentaje de algodn")
# Grfico de puntos apropiado cuando hay pocos datos:
stripchart(medida ~ grupo) 

## Homocedasticidad: Homogeneidad de varianzas
## Son iguales las varianzas dentro de cada nivel?
tapply(medida, grupo, var)
bartlett.test(medida ~ grupo) # requiere normalidad de los datos
library(car)
leveneTest(medida, grupo)

## ANOVA
## por defecto el primer nivel del factor es cero
options("contrasts")
## podemos cambiar:
#  op <- options(contrasts=c("contr.sum", "contr.poly"), show.signif.stars=FALSE)

modelo <- lm(medida ~ grupo)
anova(modelo)

## Test no paramtrico (no necesita normalidad ni homocedasticidad)
kruskal.test(medida ~ grupo)

## Intervalos de confianza para las medias
library(Rcmdr) # para acceder a la funcin plotMeans
plotMeans(medida, grupo, error.bars="conf.int", level=0.95)

## ANOVA con la funcin aov
coto.aov <- aov(medida ~ grupo)
coto.aov
summary(coto.aov)

## Coeficientes del modelo
coef(coto.aov)
# Ms detallado, muestra tambin los coeficientes "virtuales", que no estan realmente
# dentro de 'coto.aov'. Observemos la restriccin alpha_1 = 0
dummy.coef(coto.aov)

## Normalidad de los residuos
residuals(coto.aov)
# Pulsando 'ENTER' aparecen varios grficos de diagnstico,
# en particular, en el grfico de probabilidad (qqplot) si los resduos aparecen
# razonablemente alineados se acepta la normalidad.
plot(coto.aov)
# plot(modelo) # los mismos grficos

# Si nicamente estamos interesados en el grfico QQ de los residuos:
qqnorm(residuals(coto.aov))

#########################################################################################
## COMPARACIONES MULTIPLES  
#########################################################################################

plot.design(coto, fun="mean")

## Anlisis de diferencia de medias
# Si el ANOVA indica que el factor es significativo, procedemos a
# realizar pruebas post-hoc de comparacin mltiple:

require(agricolae) # paquete orientado al diseo de experimentos

## Least significant difference
LSD.test(coto.aov, "grupo", p.adj="none")
help(LSD.test)
LSD.test(coto.aov, "grupo", p.adj="bonferroni")

# Con la funcin LSD.test() se realiz la comparacin mltiple. Para obtener las
# probabilidades de las comparaciones se debe indicar que no se requiere grupos,
# LSD.test(y, trt,df, MSerror, group=F)
LSD.test(coto.aov, "grupo", p.adj="none", group=F)       # p.adj "t-student"
LSD.test(coto.aov, "grupo", p.adj="bonferroni", group=F) # p.adj "bonferroni"

## Prueba de Duncan (rangos mltiples)
duncan.test(coto.aov, "grupo", group=F)
# las tablas: http://cse.niaes.affrc.go.jp/miwa/probcalc/duncan/index.html

## Prueba de Newman-Keuls
SNK.test(coto.aov, "grupo", group=F)

## Honestly Significant Difference de Tukey
HSD.test(coto.aov, "grupo", group=F)    # paquete agricolae
TukeyHSD(coto.aov)                      # paquete stats

## Scheffe
scheffe.test(coto.aov, "grupo", group=FALSE)

## Grficos de comparacin mltiple
compara1 <- LSD.test(coto.aov, "grupo", p.adj="none", group=T)
compara2 <- SNK.test(coto.aov, "grupo", group=T)
par(mfrow=c(2,2))   #  2x2 grficos
c1 <- colors()[480]; c2 <- colors()[65]; c3 <- colors()[15]; c4 <- colors()[140]
G1 <- bar.group(compara1, ylim=c(0,45), main="LSD \n G1", col=c1)
G2 <- bar.group(compara1, horiz=T, xlim=c(0,45), main="LSD \n G2", col=c2)
G3 <- bar.group(compara2, ylim=c(0,45), main="SNK \n G3", col=c1)
G4 <- bar.group(compara2, horiz=T, xlim=c(0,45), main="SNK \n G4", col=c2)

# Una comparativa de todas las metodologias: http://www.jerrydallal.com/LHSP/mc.htm
# Otra comparativa: http://eprints.aston.ac.uk/9317/1/Statnote_6.pdf
# Otra: http://psych.colorado.edu/~carey/Courses/PSYC5741/handouts/Multiple_Comparison_Procedures.pdf

## Comparaciones mltiples con el paquete "multcomp"

require(multcomp) # paquete especial para la comparacin de medias
help(glht)

coto_T.glht <- glht(coto.aov, linfct = mcp(nivel = "Tukey"))
summary(coto_T.glht)
confint(coto_T.glht)
plot(coto_T.glht)


## Dunnet (para comparar con el grupo control)
coto_D.glht <- glht(coto.aov, linfct = mcp(nivel = "Dunnet"))
summary(coto_D.glht)
confint(coto_D.glht)
plot(coto_D.glht)


##########################################################################################
#  EXEMPLE 1:   PORPHYRA -----algas rojas--------------------------------------------------
###########################################################################################


# Petits ajustos de l'entorn R. Fem que la suma d'efectes sigui zero:
options(show.signif.stars=FALSE, contrasts=c("contr.sum", "contr.poly"))

# Lectura de les dades de producci d'esporangis
# Porphyra es un gnero de las algas rojas de cerca de 70 especies. 
# Viven en la zona intermareal, comnmente entre el intermareal superior 
# y la zona de rompimiento de las olas. En funcin de su ciclo de vida presentan 
# diferentes colores

porphyra <- read.table("./dades/PORPHYRA.DAT", header = TRUE)   
porphyra

# Anlisi de la varincia sobre aquestes dades
# Explicaci:
# Com a primer argument passem una frmula. En R un objecte de classe 'formula'
# sempre t la forma 'variable de resposta' ~ 'expressi'
# a 'expressi' hi intervenen diferents variables, a partir de les quals
# voldrem explicar els valors de la variable de resposta.
# Com a segon argument indiquem a quin 'data.frame' hi ha les variables que
# corresponen als noms de variable que s'han fet servir a la frmula.

porphyra.aov <- aov(Esporangis ~ Color, data = porphyra)
# Tamb seria el mateix:
porphyra.aov <- aov(Esporangis ~ ., data = porphyra)

# 'porphyra.aov' s un objecte complex que cont la informaci ms essencial
# de l'ajust del model lineal 'Esporangis ~ Color'.
# Si demanem que ens el mostri (equivalent a fer 'show(porphyra.aov)') genera
# un resum bastant poc informatiu:
porphyra.aov

# Hi ha diferents funcions que ens permeten extreure la informaci sobre
# diferents aspectes importants de l'ajust anterior.
# Mostra la taula ANOVA associada a l'ajust anterior:
summary(porphyra.aov)

# Coeficients del model:
coef(porphyra.aov)
# Ms detallat, mostra tamb els coeficients "virtuals", que no estan realment
# magatzemats dins 'porphyra.aov' degut a restriccions com ara que han de sumar
# zero:
dummy.coef(porphyra.aov)

# Residus:
residuals(porphyra.aov)

# Diversos grfics de diagnstic sobre els residus:
plot(porphyra.aov)

# Si nicament estessim interessats en un grfic QQ dels residus:
qqnorm(residuals(porphyra.aov))

# Diagrama de caixes per cada nivell del factor:
boxplot(Esporangis ~ Color, data = porphyra)

# Taula de mitjanes:
model.tables(porphyra.aov, type="mean")
# Taula de mitjanes amb les corresponents desviacions estndard:
model.tables(porphyra.aov, type="mean", se = TRUE)

# Com que l'ANOVA indica que el factor "Color" s significatiu, procedim a
# realitzar proves post-hoc de comparaci mltiple:
TukeyHSD(porphyra.aov)

# R bsic proporciona relativament poca cosa sobre el tema de comparacions
# mltiples, ens calen llibreries addicionals.
# Com installar una llibreria: el cam ms curt s que l'installeu des de
# l'opci de men "Paquetes" --> "Instalar paquetes". Si no ho heu fet abans,
# primer us demanar que trieu el repositori des d'on l'installareu. En trieu
# un i a continuaci ja us treur la llista de llibreries al lloc oficial CRAN,
# la trieu i pulseu OK.

# ==============================================================================
# Utilitzaci de la llibreria 'multcomp'
# ==============================================================================
require(multcomp)

porphyra.glht <- glht(porphyra.aov, linfct = mcp(Color = "Tukey"))
summary(porphyra.glht)
confint(porphyra.glht)
plot(porphyra.glht)

porphyra.glht <- glht(porphyra.aov, linfct = mcp(Color = "Schefe"))
summary(porphyra.glht)
confint(porphyra.glht)
plot(porphyra.glht)

porphyra.glht <- glht(porphyra.aov, linfct = mcp(Color = "Dunnett"))
summary(porphyra.glht)
confint(porphyra.glht)
plot(porphyra.glht)

# Sembla que sempre agafa el primer nivell com a "control". Una possible
# soluci per definir altres contrastos s indicar-los explcitament, per
# exemple per fer que "roja" sigui el nivell "control":
porphyra.glht <- glht(porphyra.aov, 
  linfct = mcp(Color = c("roja - blava = 0",
                         "roja - verda = 0",
                         "roja - groga = 0",
                         "roja - infroj = 0")
  )
)
summary(porphyra.glht)
confint(porphyra.glht)
plot(porphyra.glht)



# ==============================================================================
# Utilitzaci de la llibreria 'agricolae'
# ==============================================================================
require(agricolae)

scheffe.test(porphyra.aov, "Color")
scheffe.test(porphyra.aov, "Color", group = FALSE)

HSD.test(porphyra.aov, "Color")
HSD.test(porphyra.aov, "Color", group = FALSE)

# Com que LSD realment no controla l'error de tipus I, cal especificar un
# mtode addicional de correcci per multiplicitat (opcions: "none","holm", 
# "hochberg", "bonferroni", "BH", "BY", "fdr")
# Una bona opci podria ser "holm" que controla l'error de tipus I global i
# s vlid per p-valors dependents entre ells
LSD.test(porphyra.aov, "Color", p.adj = "holm")
LSD.test(porphyra.aov, "Color", p.adj = "holm", group = FALSE)





######################################################################################
# EXEMPLE 2:      InsectSprays - The counts of insects in agricultural experimental 
#                                units treated with different insecticides.
# A data frame with 72 observations on 2 variables.
# var 1: count   --> Insect count
# var 2: spray   --> The type of spray (factor)
####################################################################################

# Introduccin
data(InsectSprays)
boxplot(count ~ spray, data = InsectSprays,
        xlab = "Type of spray", ylab = "Insect count",
        main = "InsectSprays data", varwidth = TRUE, col = "lightgray")
fm1 <- aov(count ~ spray, data = InsectSprays)
summary(fm1)
opar <- par(mfrow = c(2,2), oma = c(0, 0, 1.1, 0))
plot(fm1)
fm2 <- aov(sqrt(count) ~ spray, data = InsectSprays)
summary(fm2)
plot(fm2)
par(opar)

# Anova de un factor con 12 rplicas por nivel
head(InsectSprays)
summary(InsectSprays)

# verificacion de la homogeneidad de varianzas
boxplot(count~spray,InsectSprays)

bartlett.test(InsectSprays$count, InsectSprays$spray)   # test de bartlett para ver si todas las varianzas son homogeneas entre grupos 

boxplot(sqrt(count)~spray,InsectSprays)  # transformacion raiz cuadrada

bartlett.test(sqrt(InsectSprays$count), InsectSprays$spray)   # ahora el test de bartlett sale no sifnificativo-> homocedasticidad


mod1=aov(sqrt(count)~spray,InsectSprays)
summary(mod1)
contrasts(InsectSprays$spray)  # para ver la codificacion de la variable factor
model.tables(mod1) # medias de los efectos, respecto a la media global.
model.tables(mod1,type="means") # medias  generales de los grupos
sort(model.tables(mod1,"mean")[[1]]$spray)  # ordenar las medias de los efectos

# test posthoc de comparacion de medias
pairwise.t.test(sqrt(InsectSprays$count), InsectSprays$spray,p.adjust.method="bonferroni")
TukeyHSD(mod1)